import React from "react"

export type Page = {
  title: string,
  url: string,
  enabled: boolean,
  icon?: React.ReactNode
}

export type PageCollection = Omit<Page, "url"> & {
  items: readonly Page[],
}

export type RouteOption = PageCollection | Page

export type Routing = {
  navigation: readonly RouteOption[]
  actions: readonly Page[]

  /**
   * Sub pages of the settings route rendered as tabs
   * on the app/(site)/settings/layout.tsx file
   */
  settings: readonly Page[]
}
